/**
 * Copyright 2020 The SkyWater PDK Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

`ifndef SKY130_EF_IO__ANALOG_NOESD_PAD_V
`define SKY130_EF_IO__ANALOG_NOESD_PAD_V

/**
 * analog_noesd_pad: Analog PAD, without ESD structures.
 *
 * Verilog top module.
 *
 * WARNING: This file is autogenerated, do not modify directly!
 */

`timescale 1ns / 1ps
`default_nettype none

`ifdef USE_POWER_PINS

`ifdef FUNCTIONAL

/*
 * Copyright 2020 The SkyWater PDK Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
*/

module sky130_ef_io__analog_noesd_pad (AMUXBUS_A, AMUXBUS_B, P_PAD, P_CORE
                                 ,VCCD, VCCHIB, VDDA, VDDIO, VDDIO_Q, VSSA, VSSD, VSSIO, VSSIO_Q, VSWITCH
                                );
inout AMUXBUS_A;
inout AMUXBUS_B;
inout P_PAD;
inout P_CORE;
inout VCCD;
inout VCCHIB;
inout VDDA;
inout VDDIO;
inout VDDIO_Q;
inout VSSA;
inout VSSD;
inout VSSIO;
inout VSSIO_Q;
inout VSWITCH;
wire pwr_good = VDDIO===1 && VSSIO===0;
wire pad_sw = pwr_good===1 ? 1'b1 : 1'bx;
tranif1 x_pad (P_PAD, P_CORE, pad_sw);
endmodule

`else  // FUNCTIONAL

/*
 * Copyright 2020 The SkyWater PDK Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
*/

module sky130_ef_io__analog_noesd_pad (AMUXBUS_A, AMUXBUS_B, P_PAD, P_CORE
                                 ,VCCD, VCCHIB, VDDA, VDDIO, VDDIO_Q, VSSA, VSSD, VSSIO, VSSIO_Q, VSWITCH
                                );
inout AMUXBUS_A;
inout AMUXBUS_B;
inout P_PAD;
inout P_CORE;
inout VCCD;
inout VCCHIB;
inout VDDA;
inout VDDIO;
inout VDDIO_Q;
inout VSSA;
inout VSSD;
inout VSSIO;
inout VSSIO_Q;
inout VSWITCH;
wire pwr_good = VDDIO===1 && VSSIO===0;
wire pad_sw = pwr_good===1 ? 1'b1 : 1'bx;
tranif1 x_pad (P_PAD, P_CORE, pad_sw);
endmodule

`endif // FUNCTIONAL

`else  // USE_POWER_PINS

`ifdef FUNCTIONAL

/*
 * Copyright 2020 The SkyWater PDK Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
*/

module sky130_ef_io__analog_noesd_pad (AMUXBUS_A, AMUXBUS_B, P_PAD, P_CORE
                                );
inout AMUXBUS_A;
inout AMUXBUS_B;
inout P_PAD;
inout P_CORE;
supply1 VCCD;
supply1 VCCHIB;
supply1 VDDA;
supply1 VDDIO;
supply1 VDDIO_Q;
supply0 VSSA;
supply0 VSSD;
supply0 VSSIO;
supply0 VSSIO_Q;
supply1 VSWITCH;
wire pwr_good = 1;
wire pad_sw = pwr_good===1 ? 1'b1 : 1'bx;
tranif1 x_pad (P_PAD, P_CORE, pad_sw);
endmodule

`else  // FUNCTIONAL

/*
 * Copyright 2020 The SkyWater PDK Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
*/

module sky130_ef_io__analog_noesd_pad (AMUXBUS_A, AMUXBUS_B, P_PAD, P_CORE
                                );
inout AMUXBUS_A;
inout AMUXBUS_B;
inout P_PAD;
inout P_CORE;
supply1 VCCD;
supply1 VCCHIB;
supply1 VDDA;
supply1 VDDIO;
supply1 VDDIO_Q;
supply0 VSSA;
supply0 VSSD;
supply0 VSSIO;
supply0 VSSIO_Q;
supply1 VSWITCH;
wire pwr_good = 1;
wire pad_sw = pwr_good===1 ? 1'b1 : 1'bx;
tranif1 x_pad (P_PAD, P_CORE, pad_sw);
endmodule

`endif // FUNCTIONAL

`endif // USE_POWER_PINS

`default_nettype wire
`endif  // SKY130_EF_IO__ANALOG_NOESD_PAD_V
